	  
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_GERA_MOV_VENDAS_DOMINIO]') AND type in (N'P', N'PC'))
    DROP PROCEDURE [dbo].[P_GERA_MOV_VENDAS_DOMINIO]
GO 
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20220907
'Job.................:  
'Nome................: [P_GERA_NFE]
'Objetivo............: 
'Tabelas.............: 
'Dt Criao..........: 07/09/2022
'Dt Ult Alteraco....: --
'Criado por..........: --
'Alterado por........: Marcos Barros
'=======================================================================================

*/
CREATE  PROCEDURE [dbo].[P_GERA_MOV_VENDAS_DOMINIO] (@CD_FILIAL INT, @DT_INI DATE, @DT_FIM DATE , @CD_MOV_VEND INT = 0)
AS
			-- EXEC P_GERA_MOV_VENDAS_DOMINIO  11,  '08/01/2022', '08/29/2022', 0
				   
			SET NOCOUNT ON;

			--CRIANDO TABELAS TEMPORARIAS  
			CREATE TABLE #MOV_VEND
				(
					[OPERACAO] VARCHAR(150),
					[CD_MOVIMENTO] INT,
					[NR_DOC] VARCHAR(200),
					[NR_DP] BIGINT,
					[TP_TRANSA] VARCHAR(3),
					[DT_MOV] NVARCHAR(4000),
					[COD_CONTA] INT,
					[COD_CONTA_DEBITO] INT,
					[COD_CONTA_CREDITO] INT,
					[VALOR] MONEY,
					[COD_HISTORICO] INT,
					[COMPLEMENTO_HISTORICO] VARCHAR(8000),
					[INICIA_LOTE] INT,
					[CODIGO_FILIAL] INT,
					[CENTRO_DE_CUSTO_DEBITO] INT,
					[CENTRO_DE_CUSTO_CREDITO] INT
				);
		------------------------------------------------------------------
			CREATE TABLE #LINHA_UNICA
				(
					[OPERACAO] VARCHAR(150),
					[CD_MOVIMENTO] INT,
					[NR_DOC] VARCHAR(200),
					[NR_DP] BIGINT,
					[TP_TRANSA] VARCHAR(3),
					[DT_MOV] NVARCHAR(4000),
					[COD_CONTA] INT,
					[COD_CONTA_DEBITO] INT,
					[COD_CONTA_CREDITO] INT,
					[VALOR] MONEY,
					[COD_HISTORICO] INT,
					[COMPLEMENTO_HISTORICO] VARCHAR(8000),
					[INICIA_LOTE] INT,
					[CODIGO_FILIAL] INT,
					[CENTRO_DE_CUSTO_DEBITO] INT,
					[CENTRO_DE_CUSTO_CREDITO] INT
				);

					  UPDATE STATISTICS dbo.PRC_FILIAL_DEPOSITO_AUXILIAR

--MOVIMENTO DE VENDA = 2 e 4 
--------------------------------------------------------------------------------------------------------------------------
		IF(@CD_MOV_VEND = 2 OR @CD_MOV_VEND = 4  OR @CD_MOV_VEND = 0)
		BEGIN
			--CARREGANDO TABELA DE #MOV_VEND  
			PRINT 'INSERINDO #MOV_VEND CD_MOVIMENTO = 2 e 4 ';

			INSERT INTO #MOV_VEND
			SELECT 
				OPERACAO										AS OPERACAO,
				CD_MOVIMENTO									AS CD_MOVIMENTO,
				NR_DOC											AS NR_DOC,
				NR_DP											AS NR_DP,
				TP_TRANSA										AS TP_TRANSA,
				FORMAT (CTB_EXP_MOV.DT_MOV,'dd/MM/yyyy')		AS DT_MOV,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) = 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) <> 0 THEN CD_CNT_RED_DEBITO
					ELSE ISNULL(CD_CNT_RED, 0) 
				END												AS COD_CONTA_DEBITO,
				CASE 
					WHEN ISNULL(CD_CNT_RED, 0)	<> 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA_CREDITO,
			   ISNULL(VLR_LANC, 0)								AS VALOR, 
			   0												AS COD_HISTORICO,
			   ISNULL(REPLACE(REPLACE(REPLACE(HIST, CHAR(9), ' '), CHAR(10), ' '), CHAR(13), ' '), '') AS COMPLEMENTO_HISTORICO,
			   CASE 
				WHEN OPERACAO = 'TRANSFERENCIA DINHEIRO - CREDITO' THEN 1  
				ELSE 0
			   END												AS INICIA_LOTE, 
			   PRC_FILIAL.CD_FILIAL								AS CODIGO_FILIAL , 
			   0												AS CENTRO_DE_CUSTO_DEBITO, 
			   0												AS CENTRO_DE_CUSTO_CREDITO
		 FROM 
			CTB_EXP_MOV
			INNER JOIN PRC_FILIAL ON 
				CTB_EXP_MOV.CD_EMP		= PRC_FILIAL.CD_EMP AND 
				CTB_EXP_MOV.CD_FILIAL	= PRC_FILIAL.CD_FILIAL
			INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON 
				PRC_FILIAL.CD_EMP		= PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND
				PRC_FILIAL.CD_FILIAL	= PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL

		WHERE 
			PRC_FILIAL.CD_FILIAL = @CD_FILIAL AND
			CTB_EXP_MOV.CD_MOVIMENTO IN (2,4) AND						-----tipos de movimentos a exportar                 
		--	DT_MOV BETWEEN '08/01/2022' AND '08/29/2022' AND			-----data seleo a exportar
			DT_MOV BETWEEN @DT_INI AND @DT_FIM AND						
		--	PRC_FILIAL.CD_FILIAL = 11 AND
			VLR_LANC > 0 
		ORDER BY 
			NR_DP, CD_MOVIMENTO, CTB_EXP_MOV.CD_FILIAL, CTB_EXP_MOV.DT_MOV, TIPO_LANCTO DESC, CD_LANC	


--------------------------------------------------------------------------------------------------------------------------
			--CARREGANDO LINHA UNICA  #MOV_VEND
			PRINT 'CARREGANDO LINHA UNICA CD_MOVIMENTO = 2 e 4 ';
			INSERT INTO #LINHA_UNICA
			SELECT * FROM
			(
				SELECT A.* FROM #MOV_VEND A
				WHERE 
					A.INICIA_LOTE = 1 AND
					EXISTS (SELECT 1 FROM #MOV_VEND B
								WHERE 
										B.CODIGO_FILIAL = A.CODIGO_FILIAL
									AND a.NR_DOC		= b.NR_DOC
									AND B.DT_MOV = A.DT_MOV
									AND B.VALOR = A.VALOR 
									AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
									AND B.INICIA_LOTE = 0
									AND b.CD_MOVIMENTO IN (2, 4)
									AND a.CD_MOVIMENTO IN (2, 4))
				UNION ALL
    
				SELECT * FROM #MOV_VEND A	
				WHERE	
					A.INICIA_LOTE = 0 AND
					NOT EXISTS (SELECT 1 FROM #MOV_VEND B	
									WHERE 
											B.CODIGO_FILIAL = A.CODIGO_FILIAL
										AND a.NR_DOC		= b.NR_DOC
										AND B.DT_MOV		= A.DT_MOV
										AND B.VALOR			= A.VALOR
										AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
										AND B.INICIA_LOTE	= 1
										AND b.CD_MOVIMENTO IN (2, 4)
										AND a.CD_MOVIMENTO IN (2, 4))
			) T
			WHERE t.CODIGO_FILIAL = @CD_FILIAL
			ORDER BY NR_DOC,
					 NR_DP,
					 INICIA_LOTE DESC;
		END;




--MOVIMENTO DE VENDA = 7
--------------------------------------------------------------------------------------------------------------------------
		IF(@CD_MOV_VEND = 7 OR @CD_MOV_VEND = 0)
		BEGIN
			--CARREGANDO TABELA DE #MOV_VEND  
			PRINT 'INSERINDO #MOV_VEND CD_MOVIMENTO = 7';

			INSERT INTO #MOV_VEND
			SELECT 
				OPERACAO										AS OPERACAO,
				CD_MOVIMENTO									AS CD_MOVIMENTO,
				NR_DOC											AS NR_DOC,
				NR_DP											AS NR_DP,
				TP_TRANSA										AS TP_TRANSA,
				FORMAT (CTB_EXP_MOV.DT_MOV,'dd/MM/yyyy')		AS DT_MOV,
							CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) = 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) <> 0 THEN CD_CNT_RED_DEBITO
					ELSE ISNULL(CD_CNT_RED, 0) 
				END												AS COD_CONTA_DEBITO,
				CASE 
					WHEN ISNULL(CD_CNT_RED, 0)	<> 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA_CREDITO,
			   ISNULL(VLR_LANC, 0)								AS VALOR, 
			   0												AS COD_HISTORICO,
			   ISNULL(REPLACE(REPLACE(REPLACE(HIST, CHAR(9), ' '), CHAR(10), ' '), CHAR(13), ' '), '') AS COMPLEMENTO_HISTORICO,
			   CASE 
				WHEN OPERACAO = 'TRANSFERENCIA DINHEIRO - CREDITO' THEN 1  
				ELSE 0
			   END												AS INICIA_LOTE, 
			   PRC_FILIAL.CD_FILIAL								AS CODIGO_FILIAL , 
			   0												AS CENTRO_DE_CUSTO_DEBITO, 
			   0												AS CENTRO_DE_CUSTO_CREDITO
		 FROM 
			CTB_EXP_MOV
			INNER JOIN PRC_FILIAL ON 
				CTB_EXP_MOV.CD_EMP		= PRC_FILIAL.CD_EMP AND 
				CTB_EXP_MOV.CD_FILIAL	= PRC_FILIAL.CD_FILIAL
			INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON 
				PRC_FILIAL.CD_EMP		= PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND
				PRC_FILIAL.CD_FILIAL	= PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL

		WHERE 
			PRC_FILIAL.CD_FILIAL = @CD_FILIAL AND
			CTB_EXP_MOV.CD_MOVIMENTO IN (7) AND						-----tipos de movimentos a exportar  ---20,21,                
			DT_MOV BETWEEN @DT_INI AND @DT_FIM AND					-----data seleo a exportar
			-- DT_MOV BETWEEN '08/01/2022' AND '08/29/2022' AND
			-- PRC_FILIAL.CD_FILIAL = 11 AND
			VLR_LANC > 0 
		ORDER BY 
			NR_DP, CD_MOVIMENTO, CTB_EXP_MOV.CD_FILIAL, CTB_EXP_MOV.DT_MOV, TIPO_LANCTO DESC, CD_LANC	


--------------------------------------------------------------------------------------------------------------------------
			--CARREGANDO LINHA UNICA  #MOV_VEND 
			PRINT 'CARREGANDO LINHA UNICA CD_MOVIMENTO = 7 ';
			INSERT INTO #LINHA_UNICA
			SELECT * FROM
			(
				SELECT A.* FROM #MOV_VEND A
				WHERE 
					A.INICIA_LOTE = 1 AND
					EXISTS (SELECT 1 FROM #MOV_VEND B
								WHERE 
										B.CODIGO_FILIAL = A.CODIGO_FILIAL
									AND a.NR_DOC		= b.NR_DOC
									AND B.DT_MOV = A.DT_MOV
									AND B.VALOR = A.VALOR 
									AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
									AND B.INICIA_LOTE = 0
									AND b.CD_MOVIMENTO IN (7)
									AND a.CD_MOVIMENTO IN (7))
				UNION ALL
    
				SELECT * FROM #MOV_VEND A	
				WHERE	
					A.INICIA_LOTE = 0 AND
					NOT EXISTS (SELECT 1 FROM #MOV_VEND B	
									WHERE 
											B.CODIGO_FILIAL = A.CODIGO_FILIAL
										AND a.NR_DOC		= b.NR_DOC
										AND B.DT_MOV		= A.DT_MOV
										AND B.VALOR			= A.VALOR
										AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
										AND B.INICIA_LOTE	= 1
										AND b.CD_MOVIMENTO IN (7)
										AND a.CD_MOVIMENTO IN (7))
			) T
			WHERE t.CODIGO_FILIAL = @CD_FILIAL
			ORDER BY NR_DOC,
					 NR_DP,
					 INICIA_LOTE DESC;
		END;



--------------------------------------------------------------------------------------------------------------------------
--MOVIMENTO DE VENDA = 8
--------------------------------------------------------------------------------------------------------------------------
		IF(@CD_MOV_VEND = 8 OR @CD_MOV_VEND = 0)
		BEGIN
			--CARREGANDO TABELA DE #MOV_VEND  
			PRINT 'INSERINDO #MOV_VEND CD_MOVIMENTO = 8';

			INSERT INTO #MOV_VEND
			SELECT 
				OPERACAO										AS OPERACAO,
				CD_MOVIMENTO									AS CD_MOVIMENTO,
				NR_DOC											AS NR_DOC,
				NR_DP											AS NR_DP,
				TP_TRANSA										AS TP_TRANSA,
				FORMAT (CTB_EXP_MOV.DT_MOV,'dd/MM/yyyy')		AS DT_MOV,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) = 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) <> 0 THEN CD_CNT_RED_DEBITO
					ELSE ISNULL(CD_CNT_RED, 0) 
				END												AS COD_CONTA_DEBITO,
				CASE 
					WHEN ISNULL(CD_CNT_RED, 0)	<> 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA_CREDITO,
			   ISNULL(VLR_LANC, 0)								AS VALOR, 
			   0												AS COD_HISTORICO,
			   ISNULL(REPLACE(REPLACE(REPLACE(HIST, CHAR(9), ' '), CHAR(10), ' '), CHAR(13), ' '), '') AS COMPLEMENTO_HISTORICO,
			   CASE 
				WHEN OPERACAO = 'TRANSFERENCIA DINHEIRO - CREDITO' THEN 1  
				ELSE 0
			   END												AS INICIA_LOTE, 
			   PRC_FILIAL.CD_FILIAL								AS CODIGO_FILIAL , 
			   0												AS CENTRO_DE_CUSTO_DEBITO, 
			   0												AS CENTRO_DE_CUSTO_CREDITO
		 FROM 
			CTB_EXP_MOV
			INNER JOIN PRC_FILIAL ON 
				CTB_EXP_MOV.CD_EMP		= PRC_FILIAL.CD_EMP AND 
				CTB_EXP_MOV.CD_FILIAL	= PRC_FILIAL.CD_FILIAL
			INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON 
				PRC_FILIAL.CD_EMP		= PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND
				PRC_FILIAL.CD_FILIAL	= PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL

		WHERE 
			PRC_FILIAL.CD_FILIAL = @CD_FILIAL AND
			CTB_EXP_MOV.CD_MOVIMENTO IN (8) AND						-----tipos de movimentos a exportar  ---20,21,                
			DT_MOV BETWEEN @DT_INI AND @DT_FIM AND					-----data seleo a exportar
			-- DT_MOV BETWEEN '08/01/2022' AND '08/29/2022' AND
			-- PRC_FILIAL.CD_FILIAL = 11 AND
			VLR_LANC > 0 
		ORDER BY 
			NR_DP, CD_MOVIMENTO, CTB_EXP_MOV.CD_FILIAL, CTB_EXP_MOV.DT_MOV, TIPO_LANCTO DESC, CD_LANC	



------------------------------------------------------------------------
			--CARREGANDO LINHA UNICA  #MOV_VEND 
------------------------------------------------------------------------

			PRINT 'CARREGANDO LINHA UNICA CD_MOVIMENTO = 8 ';
			INSERT INTO #LINHA_UNICA
			SELECT * FROM
			(
				SELECT A.* FROM #MOV_VEND A
				WHERE 
					A.INICIA_LOTE = 1 AND
					EXISTS (SELECT 1 FROM #MOV_VEND B
								WHERE 
										B.CODIGO_FILIAL = A.CODIGO_FILIAL
									AND a.NR_DOC		= b.NR_DOC
									AND B.DT_MOV = A.DT_MOV
									AND B.VALOR = A.VALOR 
									AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
									AND B.INICIA_LOTE = 0
									AND b.CD_MOVIMENTO IN (8)
									AND a.CD_MOVIMENTO IN (8))
				UNION ALL
    
				SELECT * FROM #MOV_VEND A	
				WHERE	
					A.INICIA_LOTE = 0 AND
					NOT EXISTS (SELECT 1 FROM #MOV_VEND B	
									WHERE 
											B.CODIGO_FILIAL = A.CODIGO_FILIAL
										AND a.NR_DOC		= b.NR_DOC
										AND B.DT_MOV		= A.DT_MOV
										AND B.VALOR			= A.VALOR
										AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
										AND B.INICIA_LOTE	= 1
										AND b.CD_MOVIMENTO IN (8)
										AND a.CD_MOVIMENTO IN (8))
			) T
			WHERE 
				t.CODIGO_FILIAL = @CD_FILIAL
		--		t.CODIGO_FILIAL = 11
			ORDER BY NR_DOC,
					 NR_DP,
					 INICIA_LOTE DESC;
		END;




--------------------------------------------------------------------------------------------------------------------------
--MOVIMENTO DE VENDA = 11
--------------------------------------------------------------------------------------------------------------------------
		IF(@CD_MOV_VEND = 11 OR @CD_MOV_VEND = 0)
		BEGIN
			--CARREGANDO TABELA DE #MOV_VEND  
			PRINT 'INSERINDO #MOV_VEND CD_MOVIMENTO = 11';

			INSERT INTO #MOV_VEND
			SELECT 
				OPERACAO										AS OPERACAO,
				CD_MOVIMENTO									AS CD_MOVIMENTO,
				NR_DOC											AS NR_DOC,
				NR_DP											AS NR_DP,
				TP_TRANSA										AS TP_TRANSA,
				FORMAT (CTB_EXP_MOV.DT_MOV,'dd/MM/yyyy')		AS DT_MOV,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) = 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) <> 0 THEN CD_CNT_RED_DEBITO
					ELSE ISNULL(CD_CNT_RED, 0) 
				END												AS COD_CONTA_DEBITO,
				CASE 
					WHEN ISNULL(CD_CNT_RED, 0)	<> 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA_CREDITO,
			   ISNULL(VLR_LANC, 0)								AS VALOR, 
			   0												AS COD_HISTORICO,
			   ISNULL(REPLACE(REPLACE(REPLACE(HIST, CHAR(9), ' '), CHAR(10), ' '), CHAR(13), ' '), '') AS COMPLEMENTO_HISTORICO,
			   CASE 
				WHEN OPERACAO = 'TRANSFERENCIA DINHEIRO - CREDITO' THEN 1  
				ELSE 0
			   END												AS INICIA_LOTE, 
			   PRC_FILIAL.CD_FILIAL								AS CODIGO_FILIAL , 
			   0												AS CENTRO_DE_CUSTO_DEBITO, 
			   0												AS CENTRO_DE_CUSTO_CREDITO
		 FROM 
			CTB_EXP_MOV
			INNER JOIN PRC_FILIAL ON 
				CTB_EXP_MOV.CD_EMP		= PRC_FILIAL.CD_EMP AND 
				CTB_EXP_MOV.CD_FILIAL	= PRC_FILIAL.CD_FILIAL
			INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON 
				PRC_FILIAL.CD_EMP		= PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND
				PRC_FILIAL.CD_FILIAL	= PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL

		WHERE 
			PRC_FILIAL.CD_FILIAL = @CD_FILIAL AND
		--	CTB_EXP_MOV.CD_MOVIMENTO IN (11) AND						-----tipos de movimentos a exportar  ---20,21,                
			DT_MOV BETWEEN @DT_INI AND @DT_FIM AND					-----data seleo a exportar
		--	 DT_MOV BETWEEN '08/01/2022' AND '08/29/2022' AND
			 PRC_FILIAL.CD_FILIAL = 11 AND
			VLR_LANC > 0 
		ORDER BY 
			NR_DP, CD_MOVIMENTO, CTB_EXP_MOV.CD_FILIAL, CTB_EXP_MOV.DT_MOV, TIPO_LANCTO DESC, CD_LANC	



------------------------------------------------------------------------
			--CARREGANDO LINHA UNICA  #MOV_VEND 
------------------------------------------------------------------------

			PRINT 'CARREGANDO LINHA UNICA CD_MOVIMENTO = 11 ';
			INSERT INTO #LINHA_UNICA
			SELECT * FROM
			(
				SELECT A.* FROM #MOV_VEND A
				WHERE 
					A.INICIA_LOTE = 1 AND
					EXISTS (SELECT 1 FROM #MOV_VEND B
								WHERE 
										B.CODIGO_FILIAL = A.CODIGO_FILIAL
									AND a.NR_DOC		= b.NR_DOC
									AND B.DT_MOV = A.DT_MOV
									AND B.VALOR = A.VALOR 
									AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
									AND B.INICIA_LOTE = 0
									AND b.CD_MOVIMENTO IN (11)
									AND a.CD_MOVIMENTO IN (11))
				UNION ALL
    
				SELECT * FROM #MOV_VEND A	
				WHERE	
					A.INICIA_LOTE = 0 AND
					NOT EXISTS (SELECT 1 FROM #MOV_VEND B	
									WHERE 
											B.CODIGO_FILIAL = A.CODIGO_FILIAL
										AND a.NR_DOC		= b.NR_DOC
										AND B.DT_MOV		= A.DT_MOV
										AND B.VALOR			= A.VALOR
										AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
										AND B.INICIA_LOTE	= 1
										AND b.CD_MOVIMENTO IN (11)
										AND a.CD_MOVIMENTO IN (11))
			) T
			WHERE 
			t.CODIGO_FILIAL = @CD_FILIAL
			--   t.CODIGO_FILIAL = 11
			ORDER BY NR_DOC,
					 NR_DP,
					 INICIA_LOTE DESC;
		END;



--------------------------------------------------------------------------------------------------------------------------
--MOVIMENTO DE VENDA = 12
--------------------------------------------------------------------------------------------------------------------------
		IF(@CD_MOV_VEND = 12 OR @CD_MOV_VEND = 0)
		BEGIN
			--CARREGANDO TABELA DE #MOV_VEND  
			PRINT 'INSERINDO #MOV_VEND CD_MOVIMENTO = 12';

			INSERT INTO #MOV_VEND
			SELECT 
				OPERACAO										AS OPERACAO,
				CD_MOVIMENTO									AS CD_MOVIMENTO,
				NR_DOC											AS NR_DOC,
				NR_DP											AS NR_DP,
				TP_TRANSA										AS TP_TRANSA,
				FORMAT (CTB_EXP_MOV.DT_MOV,'dd/MM/yyyy')		AS DT_MOV,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) = 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) <> 0 THEN CD_CNT_RED_DEBITO
					ELSE ISNULL(CD_CNT_RED, 0) 
				END												AS COD_CONTA_DEBITO,
				CASE 
					WHEN ISNULL(CD_CNT_RED, 0)	<> 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA_CREDITO,
			   ISNULL(VLR_LANC, 0)								AS VALOR, 
			   0												AS COD_HISTORICO,
			   ISNULL(REPLACE(REPLACE(REPLACE(HIST, CHAR(9), ' '), CHAR(10), ' '), CHAR(13), ' '), '') AS COMPLEMENTO_HISTORICO,
			   CASE 
				WHEN OPERACAO = 'TRANSFERENCIA DINHEIRO - CREDITO' THEN 1  
				ELSE 0
			   END												AS INICIA_LOTE, 
			   PRC_FILIAL.CD_FILIAL								AS CODIGO_FILIAL , 
			   0												AS CENTRO_DE_CUSTO_DEBITO, 
			   0												AS CENTRO_DE_CUSTO_CREDITO
		 FROM 
			CTB_EXP_MOV
			INNER JOIN PRC_FILIAL ON 
				CTB_EXP_MOV.CD_EMP		= PRC_FILIAL.CD_EMP AND 
				CTB_EXP_MOV.CD_FILIAL	= PRC_FILIAL.CD_FILIAL
			INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON 
				PRC_FILIAL.CD_EMP		= PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND
				PRC_FILIAL.CD_FILIAL	= PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL

		WHERE 
			PRC_FILIAL.CD_FILIAL = @CD_FILIAL AND
			CTB_EXP_MOV.CD_MOVIMENTO IN (12) AND						-----tipos de movimentos a exportar  ---20,21,                
			DT_MOV BETWEEN @DT_INI AND @DT_FIM AND					-----data seleo a exportar
			-- DT_MOV BETWEEN '08/01/2022' AND '08/29/2022' AND
			-- PRC_FILIAL.CD_FILIAL = 12 AND
			VLR_LANC > 0 
		ORDER BY 
			NR_DP, CD_MOVIMENTO, CTB_EXP_MOV.CD_FILIAL, CTB_EXP_MOV.DT_MOV, TIPO_LANCTO DESC, CD_LANC	



------------------------------------------------------------------------
			--CARREGANDO LINHA UNICA  #MOV_VEND 
------------------------------------------------------------------------

			PRINT 'CARREGANDO LINHA UNICA CD_MOVIMENTO = 12 ';
			INSERT INTO #LINHA_UNICA
			SELECT * FROM
			(
				SELECT A.* FROM #MOV_VEND A
				WHERE 
					A.INICIA_LOTE = 1 AND
					EXISTS (SELECT 1 FROM #MOV_VEND B
								WHERE 
										B.CODIGO_FILIAL = A.CODIGO_FILIAL
									AND a.NR_DOC		= b.NR_DOC
									AND B.DT_MOV = A.DT_MOV
									AND B.VALOR = A.VALOR 
									AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
									AND B.INICIA_LOTE = 0
									AND b.CD_MOVIMENTO IN (12)
									AND a.CD_MOVIMENTO IN (12))
				UNION ALL
    
				SELECT * FROM #MOV_VEND A	
				WHERE	
					A.INICIA_LOTE = 0 AND
					NOT EXISTS (SELECT 1 FROM #MOV_VEND B	
									WHERE 
											B.CODIGO_FILIAL = A.CODIGO_FILIAL
										AND a.NR_DOC		= b.NR_DOC
										AND B.DT_MOV		= A.DT_MOV
										AND B.VALOR			= A.VALOR
										AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
										AND B.INICIA_LOTE	= 1
										AND b.CD_MOVIMENTO IN (12)
										AND a.CD_MOVIMENTO IN (12))
			) T
			WHERE t.CODIGO_FILIAL = @CD_FILIAL
			ORDER BY NR_DOC,
					 NR_DP,
					 INICIA_LOTE DESC;
		END;



--------------------------------------------------------------------------------------------------------------------------
--MOVIMENTO DE VENDA = 13
--------------------------------------------------------------------------------------------------------------------------
		IF(@CD_MOV_VEND = 13 OR @CD_MOV_VEND = 0)
		BEGIN
			--CARREGANDO TABELA DE #MOV_VEND  
			PRINT 'INSERINDO #MOV_VEND CD_MOVIMENTO = 13';

			INSERT INTO #MOV_VEND
			SELECT 
				OPERACAO										AS OPERACAO,
				CD_MOVIMENTO									AS CD_MOVIMENTO,
				NR_DOC											AS NR_DOC,
				NR_DP											AS NR_DP,
				TP_TRANSA										AS TP_TRANSA,
				FORMAT (CTB_EXP_MOV.DT_MOV,'dd/MM/yyyy')		AS DT_MOV,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) = 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) <> 0 THEN CD_CNT_RED_DEBITO
					ELSE ISNULL(CD_CNT_RED, 0) 
				END												AS COD_CONTA_DEBITO,
				CASE 
					WHEN ISNULL(CD_CNT_RED, 0)	<> 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA_CREDITO,
			   ISNULL(VLR_LANC, 0)								AS VALOR, 
			   0												AS COD_HISTORICO,
			   ISNULL(REPLACE(REPLACE(REPLACE(HIST, CHAR(9), ' '), CHAR(10), ' '), CHAR(13), ' '), '') AS COMPLEMENTO_HISTORICO,
			   CASE 
				WHEN OPERACAO = 'TRANSFERENCIA DINHEIRO - CREDITO' THEN 1  
				ELSE 0
			   END												AS INICIA_LOTE, 
			   PRC_FILIAL.CD_FILIAL								AS CODIGO_FILIAL , 
			   0												AS CENTRO_DE_CUSTO_DEBITO, 
			   0												AS CENTRO_DE_CUSTO_CREDITO
		 FROM 
			CTB_EXP_MOV
			INNER JOIN PRC_FILIAL ON 
				CTB_EXP_MOV.CD_EMP		= PRC_FILIAL.CD_EMP AND 
				CTB_EXP_MOV.CD_FILIAL	= PRC_FILIAL.CD_FILIAL
			INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON 
				PRC_FILIAL.CD_EMP		= PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND
				PRC_FILIAL.CD_FILIAL	= PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL

		WHERE 
			PRC_FILIAL.CD_FILIAL = @CD_FILIAL AND
			CTB_EXP_MOV.CD_MOVIMENTO IN (13) AND						-----tipos de movimentos a exportar  ---20,21,                
			DT_MOV BETWEEN @DT_INI AND @DT_FIM AND					-----data seleo a exportar
			-- DT_MOV BETWEEN '08/01/2022' AND '08/29/2022' AND
			-- PRC_FILIAL.CD_FILIAL = 13 AND
			VLR_LANC > 0 
		ORDER BY 
			NR_DP, CD_MOVIMENTO, CTB_EXP_MOV.CD_FILIAL, CTB_EXP_MOV.DT_MOV, TIPO_LANCTO DESC, CD_LANC	



------------------------------------------------------------------------
			--CARREGANDO LINHA UNICA  #MOV_VEND 
------------------------------------------------------------------------

			PRINT 'CARREGANDO LINHA UNICA CD_MOVIMENTO = 13 ';
			INSERT INTO #LINHA_UNICA
			SELECT * FROM
			(
				SELECT A.* FROM #MOV_VEND A
				WHERE 
					A.INICIA_LOTE = 1 AND
					EXISTS (SELECT 1 FROM #MOV_VEND B
								WHERE 
										B.CODIGO_FILIAL = A.CODIGO_FILIAL
									AND a.NR_DOC		= b.NR_DOC
									AND B.DT_MOV = A.DT_MOV
									AND B.VALOR = A.VALOR 
									AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
									AND B.INICIA_LOTE = 0
									AND b.CD_MOVIMENTO IN (13)
									AND a.CD_MOVIMENTO IN (13))
				UNION ALL
    
				SELECT * FROM #MOV_VEND A	
				WHERE	
					A.INICIA_LOTE = 0 AND
					NOT EXISTS (SELECT 1 FROM #MOV_VEND B	
									WHERE 
											B.CODIGO_FILIAL = A.CODIGO_FILIAL
										AND a.NR_DOC		= b.NR_DOC
										AND B.DT_MOV		= A.DT_MOV
										AND B.VALOR			= A.VALOR
										AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
										AND B.INICIA_LOTE	= 1
										AND b.CD_MOVIMENTO IN (13)
										AND a.CD_MOVIMENTO IN (13))
			) T
			WHERE t.CODIGO_FILIAL = @CD_FILIAL
			ORDER BY NR_DOC,
					 NR_DP,
					 INICIA_LOTE DESC;
		END;


--------------------------------------------------------------------------------------------------------------------------
--MOVIMENTO DE VENDA = 14
--------------------------------------------------------------------------------------------------------------------------
		IF(@CD_MOV_VEND = 14 OR @CD_MOV_VEND = 0)
		BEGIN
			--CARREGANDO TABELA DE #MOV_VEND  
			PRINT 'INSERINDO #MOV_VEND CD_MOVIMENTO = 14';

			INSERT INTO #MOV_VEND
			SELECT 
				OPERACAO										AS OPERACAO,
				CD_MOVIMENTO									AS CD_MOVIMENTO,
				NR_DOC											AS NR_DOC,
				NR_DP											AS NR_DP,
				TP_TRANSA										AS TP_TRANSA,
				FORMAT (CTB_EXP_MOV.DT_MOV,'dd/MM/yyyy')		AS DT_MOV,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) = 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) <> 0 THEN CD_CNT_RED_DEBITO
					ELSE ISNULL(CD_CNT_RED, 0) 
				END												AS COD_CONTA_DEBITO,
				CASE 
					WHEN ISNULL(CD_CNT_RED, 0)	<> 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA_CREDITO,
			   ISNULL(VLR_LANC, 0)								AS VALOR, 
			   0												AS COD_HISTORICO,
			   ISNULL(REPLACE(REPLACE(REPLACE(HIST, CHAR(9), ' '), CHAR(10), ' '), CHAR(14), ' '), '') AS COMPLEMENTO_HISTORICO,
			   CASE 
				WHEN OPERACAO = 'TRANSFERENCIA DINHEIRO - CREDITO' THEN 1  
				ELSE 0
			   END												AS INICIA_LOTE, 
			   PRC_FILIAL.CD_FILIAL								AS CODIGO_FILIAL , 
			   0												AS CENTRO_DE_CUSTO_DEBITO, 
			   0												AS CENTRO_DE_CUSTO_CREDITO
		 FROM 
			CTB_EXP_MOV
			INNER JOIN PRC_FILIAL ON 
				CTB_EXP_MOV.CD_EMP		= PRC_FILIAL.CD_EMP AND 
				CTB_EXP_MOV.CD_FILIAL	= PRC_FILIAL.CD_FILIAL
			INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON 
				PRC_FILIAL.CD_EMP		= PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND
				PRC_FILIAL.CD_FILIAL	= PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL

		WHERE 
			PRC_FILIAL.CD_FILIAL = @CD_FILIAL AND
			CTB_EXP_MOV.CD_MOVIMENTO IN (14) AND						-----tipos de movimentos a exportar  ---20,21,                
			DT_MOV BETWEEN @DT_INI AND @DT_FIM AND					-----data seleo a exportar
			-- DT_MOV BETWEEN '08/01/2022' AND '08/29/2022' AND
			-- PRC_FILIAL.CD_FILIAL = 14 AND
			VLR_LANC > 0 
		ORDER BY 
			NR_DP, CD_MOVIMENTO, CTB_EXP_MOV.CD_FILIAL, CTB_EXP_MOV.DT_MOV, TIPO_LANCTO DESC, CD_LANC	



------------------------------------------------------------------------
			--CARREGANDO LINHA UNICA  #MOV_VEND 
------------------------------------------------------------------------

			PRINT 'CARREGANDO LINHA UNICA CD_MOVIMENTO = 14 ';
			INSERT INTO #LINHA_UNICA
			SELECT * FROM
			(
				SELECT A.* FROM #MOV_VEND A
				WHERE 
					A.INICIA_LOTE = 1 AND
					EXISTS (SELECT 1 FROM #MOV_VEND B
								WHERE 
										B.CODIGO_FILIAL = A.CODIGO_FILIAL
									AND a.NR_DOC		= b.NR_DOC
									AND B.DT_MOV = A.DT_MOV
									AND B.VALOR = A.VALOR 
									AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
									AND B.INICIA_LOTE = 0
									AND b.CD_MOVIMENTO IN (14)
									AND a.CD_MOVIMENTO IN (14))
				UNION ALL
    
				SELECT * FROM #MOV_VEND A	
				WHERE	
					A.INICIA_LOTE = 0 AND
					NOT EXISTS (SELECT 1 FROM #MOV_VEND B	
									WHERE 
											B.CODIGO_FILIAL = A.CODIGO_FILIAL
										AND a.NR_DOC		= b.NR_DOC
										AND B.DT_MOV		= A.DT_MOV
										AND B.VALOR			= A.VALOR
										AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
										AND B.INICIA_LOTE	= 1
										AND b.CD_MOVIMENTO IN (14)
										AND a.CD_MOVIMENTO IN (14))
			) T
			WHERE t.CODIGO_FILIAL = @CD_FILIAL
			ORDER BY NR_DOC,
					 NR_DP,
					 INICIA_LOTE DESC;
		END;



--------------------------------------------------------------------------------------------------------------------------
--MOVIMENTO DE VENDA = 15
--------------------------------------------------------------------------------------------------------------------------
		IF(@CD_MOV_VEND = 15 OR @CD_MOV_VEND = 0)
		BEGIN
			--CARREGANDO TABELA DE #MOV_VEND  
			PRINT 'INSERINDO #MOV_VEND CD_MOVIMENTO = 15';

			INSERT INTO #MOV_VEND
			SELECT 
				OPERACAO										AS OPERACAO,
				CD_MOVIMENTO									AS CD_MOVIMENTO,
				NR_DOC											AS NR_DOC,
				NR_DP											AS NR_DP,
				TP_TRANSA										AS TP_TRANSA,
				FORMAT (CTB_EXP_MOV.DT_MOV,'dd/MM/yyyy')		AS DT_MOV,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) = 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) <> 0 THEN CD_CNT_RED_DEBITO
					ELSE ISNULL(CD_CNT_RED, 0) 
				END												AS COD_CONTA_DEBITO,
				CASE 
					WHEN ISNULL(CD_CNT_RED, 0)	<> 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA_CREDITO,
			   ISNULL(VLR_LANC, 0)								AS VALOR, 
			   0												AS COD_HISTORICO,
			   ISNULL(REPLACE(REPLACE(REPLACE(HIST, CHAR(9), ' '), CHAR(10), ' '), CHAR(15), ' '), '') AS COMPLEMENTO_HISTORICO,
			   CASE 
				WHEN OPERACAO = 'TRANSFERENCIA DINHEIRO - CREDITO' THEN 1  
				ELSE 0
			   END												AS INICIA_LOTE, 
			   PRC_FILIAL.CD_FILIAL								AS CODIGO_FILIAL , 
			   0												AS CENTRO_DE_CUSTO_DEBITO, 
			   0												AS CENTRO_DE_CUSTO_CREDITO
		 FROM 
			CTB_EXP_MOV
			INNER JOIN PRC_FILIAL ON 
				CTB_EXP_MOV.CD_EMP		= PRC_FILIAL.CD_EMP AND 
				CTB_EXP_MOV.CD_FILIAL	= PRC_FILIAL.CD_FILIAL
			INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON 
				PRC_FILIAL.CD_EMP		= PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND
				PRC_FILIAL.CD_FILIAL	= PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL

		WHERE 
			PRC_FILIAL.CD_FILIAL = @CD_FILIAL AND
			CTB_EXP_MOV.CD_MOVIMENTO IN (15) AND						-----tipos de movimentos a exportar  ---20,21,                
			DT_MOV BETWEEN @DT_INI AND @DT_FIM AND					-----data seleo a exportar
			-- DT_MOV BETWEEN '08/01/2022' AND '08/29/2022' AND
			-- PRC_FILIAL.CD_FILIAL = 15 AND
			VLR_LANC > 0 
		ORDER BY 
			NR_DP, CD_MOVIMENTO, CTB_EXP_MOV.CD_FILIAL, CTB_EXP_MOV.DT_MOV, TIPO_LANCTO DESC, CD_LANC	



------------------------------------------------------------------------
			--CARREGANDO LINHA UNICA  #MOV_VEND 
------------------------------------------------------------------------

			PRINT 'CARREGANDO LINHA UNICA CD_MOVIMENTO = 15 ';
			INSERT INTO #LINHA_UNICA
			SELECT * FROM
			(
				SELECT A.* FROM #MOV_VEND A
				WHERE 
					A.INICIA_LOTE = 1 AND
					EXISTS (SELECT 1 FROM #MOV_VEND B
								WHERE 
										B.CODIGO_FILIAL = A.CODIGO_FILIAL
									AND a.NR_DOC		= b.NR_DOC
									AND B.DT_MOV = A.DT_MOV
									AND B.VALOR = A.VALOR 
									AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
									AND B.INICIA_LOTE = 0
									AND b.CD_MOVIMENTO IN (15)
									AND a.CD_MOVIMENTO IN (15))
				UNION ALL
    
				SELECT * FROM #MOV_VEND A	
				WHERE	
					A.INICIA_LOTE = 0 AND
					NOT EXISTS (SELECT 1 FROM #MOV_VEND B	
									WHERE 
											B.CODIGO_FILIAL = A.CODIGO_FILIAL
										AND a.NR_DOC		= b.NR_DOC
										AND B.DT_MOV		= A.DT_MOV
										AND B.VALOR			= A.VALOR
										AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
										AND B.INICIA_LOTE	= 1
										AND b.CD_MOVIMENTO IN (15)
										AND a.CD_MOVIMENTO IN (15))
			) T
			WHERE t.CODIGO_FILIAL = @CD_FILIAL
			ORDER BY NR_DOC,
					 NR_DP,
					 INICIA_LOTE DESC;
		END;


--------------------------------------------------------------------------------------------------------------------------
--MOVIMENTO DE VENDA = 16
--------------------------------------------------------------------------------------------------------------------------
		IF(@CD_MOV_VEND = 16 OR @CD_MOV_VEND = 0)
		BEGIN
			--CARREGANDO TABELA DE #MOV_VEND  
			PRINT 'INSERINDO #MOV_VEND CD_MOVIMENTO = 16';

			INSERT INTO #MOV_VEND
			SELECT 
				OPERACAO										AS OPERACAO,
				CD_MOVIMENTO									AS CD_MOVIMENTO,
				NR_DOC											AS NR_DOC,
				NR_DP											AS NR_DP,
				TP_TRANSA										AS TP_TRANSA,
				FORMAT (CTB_EXP_MOV.DT_MOV,'dd/MM/yyyy')		AS DT_MOV,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) = 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) <> 0 THEN CD_CNT_RED_DEBITO
					ELSE ISNULL(CD_CNT_RED, 0) 
				END												AS COD_CONTA_DEBITO,
				CASE 
					WHEN ISNULL(CD_CNT_RED, 0)	<> 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA_CREDITO,
			   ISNULL(VLR_LANC, 0)								AS VALOR, 
			   0												AS COD_HISTORICO,
			   ISNULL(REPLACE(REPLACE(REPLACE(HIST, CHAR(9), ' '), CHAR(10), ' '), CHAR(16), ' '), '') AS COMPLEMENTO_HISTORICO,
			   CASE 
				WHEN OPERACAO = 'TRANSFERENCIA DINHEIRO - CREDITO' THEN 1  
				ELSE 0
			   END												AS INICIA_LOTE, 
			   PRC_FILIAL.CD_FILIAL								AS CODIGO_FILIAL , 
			   0												AS CENTRO_DE_CUSTO_DEBITO, 
			   0												AS CENTRO_DE_CUSTO_CREDITO
		 FROM 
			CTB_EXP_MOV
			INNER JOIN PRC_FILIAL ON 
				CTB_EXP_MOV.CD_EMP		= PRC_FILIAL.CD_EMP AND 
				CTB_EXP_MOV.CD_FILIAL	= PRC_FILIAL.CD_FILIAL
			INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON 
				PRC_FILIAL.CD_EMP		= PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND
				PRC_FILIAL.CD_FILIAL	= PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL

		WHERE 
			PRC_FILIAL.CD_FILIAL = @CD_FILIAL AND
			CTB_EXP_MOV.CD_MOVIMENTO IN (16) AND						-----tipos de movimentos a exportar  ---20,21,                
			DT_MOV BETWEEN @DT_INI AND @DT_FIM AND					-----data seleo a exportar
			-- DT_MOV BETWEEN '08/01/2022' AND '08/29/2022' AND
			-- PRC_FILIAL.CD_FILIAL = 16 AND
			VLR_LANC > 0 
		ORDER BY 
			NR_DP, CD_MOVIMENTO, CTB_EXP_MOV.CD_FILIAL, CTB_EXP_MOV.DT_MOV, TIPO_LANCTO DESC, CD_LANC	



------------------------------------------------------------------------
			--CARREGANDO LINHA UNICA  #MOV_VEND 
------------------------------------------------------------------------

			PRINT 'CARREGANDO LINHA UNICA CD_MOVIMENTO = 16 ';
			INSERT INTO #LINHA_UNICA
			SELECT * FROM
			(
				SELECT A.* FROM #MOV_VEND A
				WHERE 
					A.INICIA_LOTE = 1 AND
					EXISTS (SELECT 1 FROM #MOV_VEND B
								WHERE 
										B.CODIGO_FILIAL = A.CODIGO_FILIAL
									AND a.NR_DOC		= b.NR_DOC
									AND B.DT_MOV = A.DT_MOV
									AND B.VALOR = A.VALOR 
									AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
									AND B.INICIA_LOTE = 0
									AND b.CD_MOVIMENTO IN (16)
									AND a.CD_MOVIMENTO IN (16))
				UNION ALL
    
				SELECT * FROM #MOV_VEND A	
				WHERE	
					A.INICIA_LOTE = 0 AND
					NOT EXISTS (SELECT 1 FROM #MOV_VEND B	
									WHERE 
											B.CODIGO_FILIAL = A.CODIGO_FILIAL
										AND a.NR_DOC		= b.NR_DOC
										AND B.DT_MOV		= A.DT_MOV
										AND B.VALOR			= A.VALOR
										AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
										AND B.INICIA_LOTE	= 1
										AND b.CD_MOVIMENTO IN (16)
										AND a.CD_MOVIMENTO IN (16))
			) T
			WHERE t.CODIGO_FILIAL = @CD_FILIAL
			ORDER BY NR_DOC,
					 NR_DP,
					 INICIA_LOTE DESC;
		END;



--------------------------------------------------------------------------------------------------------------------------
--MOVIMENTO DE VENDA = 18
--------------------------------------------------------------------------------------------------------------------------
		IF(@CD_MOV_VEND = 18 OR @CD_MOV_VEND = 0)
		BEGIN
			--CARREGANDO TABELA DE #MOV_VEND  
			PRINT 'INSERINDO #MOV_VEND CD_MOVIMENTO = 18';

			INSERT INTO #MOV_VEND
			SELECT 
				OPERACAO										AS OPERACAO,
				CD_MOVIMENTO									AS CD_MOVIMENTO,
				NR_DOC											AS NR_DOC,
				NR_DP											AS NR_DP,
				TP_TRANSA										AS TP_TRANSA,
				FORMAT (CTB_EXP_MOV.DT_MOV,'dd/MM/yyyy')		AS DT_MOV,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) = 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) <> 0 THEN CD_CNT_RED_DEBITO
					ELSE ISNULL(CD_CNT_RED, 0) 
				END												AS COD_CONTA_DEBITO,
				CASE 
					WHEN ISNULL(CD_CNT_RED, 0)	<> 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA_CREDITO,
			   ISNULL(VLR_LANC, 0)								AS VALOR, 
			   0												AS COD_HISTORICO,
			   ISNULL(REPLACE(REPLACE(REPLACE(HIST, CHAR(9), ' '), CHAR(10), ' '), CHAR(18), ' '), '') AS COMPLEMENTO_HISTORICO,
			   CASE 
				WHEN OPERACAO = 'TRANSFERENCIA DINHEIRO - CREDITO' THEN 1  
				ELSE 0
			   END												AS INICIA_LOTE, 
			   PRC_FILIAL.CD_FILIAL								AS CODIGO_FILIAL , 
			   0												AS CENTRO_DE_CUSTO_DEBITO, 
			   0												AS CENTRO_DE_CUSTO_CREDITO
		 FROM 
			CTB_EXP_MOV
			INNER JOIN PRC_FILIAL ON 
				CTB_EXP_MOV.CD_EMP		= PRC_FILIAL.CD_EMP AND 
				CTB_EXP_MOV.CD_FILIAL	= PRC_FILIAL.CD_FILIAL
			INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON 
				PRC_FILIAL.CD_EMP		= PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND
				PRC_FILIAL.CD_FILIAL	= PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL

		WHERE 
			PRC_FILIAL.CD_FILIAL = @CD_FILIAL AND
			CTB_EXP_MOV.CD_MOVIMENTO IN (18) AND						-----tipos de movimentos a exportar  ---20,21,                
			DT_MOV BETWEEN @DT_INI AND @DT_FIM AND					-----data seleo a exportar
			-- DT_MOV BETWEEN '08/01/2022' AND '08/29/2022' AND
			-- PRC_FILIAL.CD_FILIAL = 18 AND
			VLR_LANC > 0 
		ORDER BY 
			NR_DP, CD_MOVIMENTO, CTB_EXP_MOV.CD_FILIAL, CTB_EXP_MOV.DT_MOV, TIPO_LANCTO DESC, CD_LANC	



------------------------------------------------------------------------
			--CARREGANDO LINHA UNICA  #MOV_VEND 
------------------------------------------------------------------------

			PRINT 'CARREGANDO LINHA UNICA CD_MOVIMENTO = 18 ';
			INSERT INTO #LINHA_UNICA
			SELECT * FROM
			(
				SELECT A.* FROM #MOV_VEND A
				WHERE 
					A.INICIA_LOTE = 1 AND
					EXISTS (SELECT 1 FROM #MOV_VEND B
								WHERE 
										B.CODIGO_FILIAL = A.CODIGO_FILIAL
									AND a.NR_DOC		= b.NR_DOC
									AND B.DT_MOV = A.DT_MOV
									AND B.VALOR = A.VALOR 
									AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
									AND B.INICIA_LOTE = 0
									AND b.CD_MOVIMENTO IN (18)
									AND a.CD_MOVIMENTO IN (18))
				UNION ALL
    
				SELECT * FROM #MOV_VEND A	
				WHERE	
					A.INICIA_LOTE = 0 AND
					NOT EXISTS (SELECT 1 FROM #MOV_VEND B	
									WHERE 
											B.CODIGO_FILIAL = A.CODIGO_FILIAL
										AND a.NR_DOC		= b.NR_DOC
										AND B.DT_MOV		= A.DT_MOV
										AND B.VALOR			= A.VALOR
										AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
										AND B.INICIA_LOTE	= 1
										AND b.CD_MOVIMENTO IN (18)
										AND a.CD_MOVIMENTO IN (18))
			) T
			WHERE t.CODIGO_FILIAL = @CD_FILIAL
			ORDER BY NR_DOC,
					 NR_DP,
					 INICIA_LOTE DESC;
		END;


--------------------------------------------------------------------------------------------------------------------------
--MOVIMENTO DE VENDA = 20
--------------------------------------------------------------------------------------------------------------------------
		IF(@CD_MOV_VEND = 20 OR @CD_MOV_VEND = 0)
		BEGIN
			--CARREGANDO TABELA DE #MOV_VEND  
			PRINT 'INSERINDO #MOV_VEND CD_MOVIMENTO = 20';

			INSERT INTO #MOV_VEND
			SELECT 
				OPERACAO										AS OPERACAO,
				CD_MOVIMENTO									AS CD_MOVIMENTO,
				NR_DOC											AS NR_DOC,
				NR_DP											AS NR_DP,
				TP_TRANSA										AS TP_TRANSA,
				FORMAT (CTB_EXP_MOV.DT_MOV,'dd/MM/yyyy')		AS DT_MOV,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) = 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) <> 0 THEN CD_CNT_RED_DEBITO
					ELSE ISNULL(CD_CNT_RED, 0) 
				END												AS COD_CONTA_DEBITO,
				CASE 
					WHEN ISNULL(CD_CNT_RED, 0)	<> 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA_CREDITO,
			   ISNULL(VLR_LANC, 0)								AS VALOR, 
			   0												AS COD_HISTORICO,
			   ISNULL(REPLACE(REPLACE(REPLACE(HIST, CHAR(9), ' '), CHAR(10), ' '), CHAR(20), ' '), '') AS COMPLEMENTO_HISTORICO,
			   CASE 
				WHEN OPERACAO = 'TRANSFERENCIA DINHEIRO - CREDITO' THEN 1  
				ELSE 0
			   END												AS INICIA_LOTE, 
			   PRC_FILIAL.CD_FILIAL								AS CODIGO_FILIAL , 
			   0												AS CENTRO_DE_CUSTO_DEBITO, 
			   0												AS CENTRO_DE_CUSTO_CREDITO
		 FROM 
			CTB_EXP_MOV
			INNER JOIN PRC_FILIAL ON 
				CTB_EXP_MOV.CD_EMP		= PRC_FILIAL.CD_EMP AND 
				CTB_EXP_MOV.CD_FILIAL	= PRC_FILIAL.CD_FILIAL
			INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON 
				PRC_FILIAL.CD_EMP		= PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND
				PRC_FILIAL.CD_FILIAL	= PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL

		WHERE 
			PRC_FILIAL.CD_FILIAL = @CD_FILIAL AND
			CTB_EXP_MOV.CD_MOVIMENTO IN (20) AND						-----tipos de movimentos a exportar  ---20,21,                
			DT_MOV BETWEEN @DT_INI AND @DT_FIM AND					-----data seleo a exportar
			-- DT_MOV BETWEEN '08/01/2022' AND '08/29/2022' AND
			-- PRC_FILIAL.CD_FILIAL = 20 AND
			VLR_LANC > 0 
		ORDER BY 
			NR_DP, CD_MOVIMENTO, CTB_EXP_MOV.CD_FILIAL, CTB_EXP_MOV.DT_MOV, TIPO_LANCTO DESC, CD_LANC	



------------------------------------------------------------------------
			--CARREGANDO LINHA UNICA  #MOV_VEND 
------------------------------------------------------------------------

			PRINT 'CARREGANDO LINHA UNICA CD_MOVIMENTO = 20 ';
			INSERT INTO #LINHA_UNICA
			SELECT * FROM
			(
				SELECT A.* FROM #MOV_VEND A
				WHERE 
					A.INICIA_LOTE = 1 AND
					EXISTS (SELECT 1 FROM #MOV_VEND B
								WHERE 
										B.CODIGO_FILIAL = A.CODIGO_FILIAL
									AND a.NR_DOC		= b.NR_DOC
									AND B.DT_MOV = A.DT_MOV
									AND B.VALOR = A.VALOR 
									AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
									AND B.INICIA_LOTE = 0
									AND b.CD_MOVIMENTO IN (20)
									AND a.CD_MOVIMENTO IN (20))
				UNION ALL
    
				SELECT * FROM #MOV_VEND A	
				WHERE	
					A.INICIA_LOTE = 0 AND
					NOT EXISTS (SELECT 1 FROM #MOV_VEND B	
									WHERE 
											B.CODIGO_FILIAL = A.CODIGO_FILIAL
										AND a.NR_DOC		= b.NR_DOC
										AND B.DT_MOV		= A.DT_MOV
										AND B.VALOR			= A.VALOR
										AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
										AND B.INICIA_LOTE	= 1
										AND b.CD_MOVIMENTO IN (20)
										AND a.CD_MOVIMENTO IN (20))
			) T
			WHERE t.CODIGO_FILIAL = @CD_FILIAL
			ORDER BY NR_DOC,
					 NR_DP,
					 INICIA_LOTE DESC;
		END;


--------------------------------------------------------------------------------------------------------------------------
--MOVIMENTO DE VENDA = 21
--------------------------------------------------------------------------------------------------------------------------
		IF(@CD_MOV_VEND = 21 OR @CD_MOV_VEND = 0)
		BEGIN
			--CARREGANDO TABELA DE #MOV_VEND  
			PRINT 'INSERINDO #MOV_VEND CD_MOVIMENTO = 21';

			INSERT INTO #MOV_VEND
			SELECT 
				OPERACAO										AS OPERACAO,
				CD_MOVIMENTO									AS CD_MOVIMENTO,
				NR_DOC											AS NR_DOC,
				NR_DP											AS NR_DP,
				TP_TRANSA										AS TP_TRANSA,
				FORMAT (CTB_EXP_MOV.DT_MOV,'dd/MM/yyyy')		AS DT_MOV,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) = 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) <> 0 THEN CD_CNT_RED_DEBITO
					ELSE ISNULL(CD_CNT_RED, 0) 
				END												AS COD_CONTA_DEBITO,
				CASE 
					WHEN ISNULL(CD_CNT_RED, 0)	<> 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA_CREDITO,
			   ISNULL(VLR_LANC, 0)								AS VALOR, 
			   0												AS COD_HISTORICO,
			   ISNULL(REPLACE(REPLACE(REPLACE(HIST, CHAR(9), ' '), CHAR(10), ' '), CHAR(21), ' '), '') AS COMPLEMENTO_HISTORICO,
			   CASE 
				WHEN OPERACAO = 'TRANSFERENCIA DINHEIRO - CREDITO' THEN 1  
				ELSE 0
			   END												AS INICIA_LOTE, 
			   PRC_FILIAL.CD_FILIAL								AS CODIGO_FILIAL , 
			   0												AS CENTRO_DE_CUSTO_DEBITO, 
			   0												AS CENTRO_DE_CUSTO_CREDITO
		 FROM 
			CTB_EXP_MOV
			INNER JOIN PRC_FILIAL ON 
				CTB_EXP_MOV.CD_EMP		= PRC_FILIAL.CD_EMP AND 
				CTB_EXP_MOV.CD_FILIAL	= PRC_FILIAL.CD_FILIAL
			INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON 
				PRC_FILIAL.CD_EMP		= PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND
				PRC_FILIAL.CD_FILIAL	= PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL

		WHERE 
			PRC_FILIAL.CD_FILIAL = @CD_FILIAL AND
			CTB_EXP_MOV.CD_MOVIMENTO IN (21) AND						-----tipos de movimentos a exportar  ---20,21,                
			DT_MOV BETWEEN @DT_INI AND @DT_FIM AND					-----data seleo a exportar
			-- DT_MOV BETWEEN '08/01/2022' AND '08/29/2022' AND
			-- PRC_FILIAL.CD_FILIAL = 21 AND
			VLR_LANC > 0 
		ORDER BY 
			NR_DP, CD_MOVIMENTO, CTB_EXP_MOV.CD_FILIAL, CTB_EXP_MOV.DT_MOV, TIPO_LANCTO DESC, CD_LANC	



------------------------------------------------------------------------
			--CARREGANDO LINHA UNICA  #MOV_VEND 
------------------------------------------------------------------------

			PRINT 'CARREGANDO LINHA UNICA CD_MOVIMENTO = 21 ';
			INSERT INTO #LINHA_UNICA
			SELECT * FROM
			(
				SELECT A.* FROM #MOV_VEND A
				WHERE 
					A.INICIA_LOTE = 1 AND
					EXISTS (SELECT 1 FROM #MOV_VEND B
								WHERE 
										B.CODIGO_FILIAL = A.CODIGO_FILIAL
									AND a.NR_DOC		= b.NR_DOC
									AND B.DT_MOV = A.DT_MOV
									AND B.VALOR = A.VALOR 
									AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
									AND B.INICIA_LOTE = 0
									AND b.CD_MOVIMENTO IN (21)
									AND a.CD_MOVIMENTO IN (21))
				UNION ALL
    
				SELECT * FROM #MOV_VEND A	
				WHERE	
					A.INICIA_LOTE = 0 AND
					NOT EXISTS (SELECT 1 FROM #MOV_VEND B	
									WHERE 
											B.CODIGO_FILIAL = A.CODIGO_FILIAL
										AND a.NR_DOC		= b.NR_DOC
										AND B.DT_MOV		= A.DT_MOV
										AND B.VALOR			= A.VALOR
										AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
										AND B.INICIA_LOTE	= 1
										AND b.CD_MOVIMENTO IN (21)
										AND a.CD_MOVIMENTO IN (21))
			) T
			WHERE t.CODIGO_FILIAL = @CD_FILIAL
			ORDER BY NR_DOC,
					 NR_DP,
					 INICIA_LOTE DESC;
		END;



--------------------------------------------------------------------------------------------------------------------------
--MOVIMENTO DE VENDA = 28
--------------------------------------------------------------------------------------------------------------------------
		IF(@CD_MOV_VEND = 28 OR @CD_MOV_VEND = 0)
		BEGIN
			--CARREGANDO TABELA DE #MOV_VEND  
			PRINT 'INSERINDO #MOV_VEND CD_MOVIMENTO = 28';

			INSERT INTO #MOV_VEND
			SELECT 
				OPERACAO										AS OPERACAO,
				CD_MOVIMENTO									AS CD_MOVIMENTO,
				NR_DOC											AS NR_DOC,
				NR_DP											AS NR_DP,
				TP_TRANSA										AS TP_TRANSA,
				FORMAT (CTB_EXP_MOV.DT_MOV,'dd/MM/yyyy')		AS DT_MOV,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) = 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA,
				CASE 
					WHEN ISNULL(CD_CNT_RED_DEBITO, 0) <> 0 THEN CD_CNT_RED_DEBITO
					ELSE ISNULL(CD_CNT_RED, 0) 
				END												AS COD_CONTA_DEBITO,
				CASE 
					WHEN ISNULL(CD_CNT_RED, 0)	<> 0 THEN ISNULL(CD_CNT_RED, 0)
					ELSE ISNULL(CD_CNT_RED_DEBITO, 0)
				END												AS COD_CONTA_CREDITO,
			   ISNULL(VLR_LANC, 0)								AS VALOR, 
			   0												AS COD_HISTORICO,
			   ISNULL(REPLACE(REPLACE(REPLACE(HIST, CHAR(9), ' '), CHAR(10), ' '), CHAR(28), ' '), '') AS COMPLEMENTO_HISTORICO,
			   CASE 
				WHEN OPERACAO = 'TRANSFERENCIA DINHEIRO - CREDITO' THEN 1  
				ELSE 0
			   END												AS INICIA_LOTE, 
			   PRC_FILIAL.CD_FILIAL								AS CODIGO_FILIAL , 
			   0												AS CENTRO_DE_CUSTO_DEBITO, 
			   0												AS CENTRO_DE_CUSTO_CREDITO
		 FROM 
			CTB_EXP_MOV
			INNER JOIN PRC_FILIAL ON 
				CTB_EXP_MOV.CD_EMP		= PRC_FILIAL.CD_EMP AND 
				CTB_EXP_MOV.CD_FILIAL	= PRC_FILIAL.CD_FILIAL
			INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON 
				PRC_FILIAL.CD_EMP		= PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND
				PRC_FILIAL.CD_FILIAL	= PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL

		WHERE 
			PRC_FILIAL.CD_FILIAL = @CD_FILIAL AND
			CTB_EXP_MOV.CD_MOVIMENTO IN (28) AND						-----tipos de movimentos a exportar  ---20,28,                
			DT_MOV BETWEEN @DT_INI AND @DT_FIM AND					-----data seleo a exportar
			-- DT_MOV BETWEEN '08/01/2022' AND '08/29/2022' AND
			-- PRC_FILIAL.CD_FILIAL = 28 AND
			VLR_LANC > 0 
		ORDER BY 
			NR_DP, CD_MOVIMENTO, CTB_EXP_MOV.CD_FILIAL, CTB_EXP_MOV.DT_MOV, TIPO_LANCTO DESC, CD_LANC	



------------------------------------------------------------------------
			--CARREGANDO LINHA UNICA  #MOV_VEND 
------------------------------------------------------------------------

			PRINT 'CARREGANDO LINHA UNICA CD_MOVIMENTO = 28 ';
			INSERT INTO #LINHA_UNICA
			SELECT * FROM
			(
				SELECT A.* FROM #MOV_VEND A
				WHERE 
					A.INICIA_LOTE = 1 AND
					EXISTS (SELECT 1 FROM #MOV_VEND B
								WHERE 
										B.CODIGO_FILIAL = A.CODIGO_FILIAL
									AND a.NR_DOC		= b.NR_DOC
									AND B.DT_MOV = A.DT_MOV
									AND B.VALOR = A.VALOR 
									AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
									AND B.INICIA_LOTE = 0
									AND b.CD_MOVIMENTO IN (28)
									AND a.CD_MOVIMENTO IN (28))
				UNION ALL
    
				SELECT * FROM #MOV_VEND A	
				WHERE	
					A.INICIA_LOTE = 0 AND
					NOT EXISTS (SELECT 1 FROM #MOV_VEND B	
									WHERE 
											B.CODIGO_FILIAL = A.CODIGO_FILIAL
										AND a.NR_DOC		= b.NR_DOC
										AND B.DT_MOV		= A.DT_MOV
										AND B.VALOR			= A.VALOR
										AND B.COMPLEMENTO_HISTORICO = A.COMPLEMENTO_HISTORICO
										AND B.INICIA_LOTE	= 1
										AND b.CD_MOVIMENTO IN (28)
										AND a.CD_MOVIMENTO IN (28))
			) T
			WHERE t.CODIGO_FILIAL = @CD_FILIAL
			ORDER BY NR_DOC,
					 NR_DP,
					 INICIA_LOTE DESC;
		END;





--------------------------------------------------------------------------------------------------------------------------
		--RETORNO VALORES LINHA UNICA
		PRINT 'RETORNO LINHA UNICA ';
		SELECT 
			CD_MOVIMENTO AS cd_mov_venda,
			DT_MOV, 
			COD_CONTA_DEBITO,
			COD_CONTA_CREDITO,
			VALOR,
			COD_HISTORICO,
			COMPLEMENTO_HISTORICO,
			INICIA_LOTE,
			CODIGO_FILIAL,
			CENTRO_DE_CUSTO_DEBITO,
			CENTRO_DE_CUSTO_CREDITO
		FROM  
			#LINHA_UNICA
		WHERE CD_MOVIMENTO = 11